## Excel Date Functions

A set of Excel like functions supported by icCube



### Return

```
void
```



### Description

A list of Excel Text functions to follow MDX standard. We would advise using Java function if available instead.
<UL>
<LI><b>CDate</b>(string s), converts a string into a datetime using formats as ('M/d/y h:m:s','M/d/y', 'M-d-y h:m:s'... )
<LI><b>Now</b>(), returns the current datetime
<LI><b>Year</b>(date), returns the year of the parameter date / datetime
<LI><b>Month</b>(date), returns the month of the parameter date / datetime
<LI><b>Day</b>(date), returns the day of the month of the parameter date / datetime
</UL>

See this [page](../mdx_types/dateandtime.md) for more details about <b>date and time</b> functions.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### CDate(string)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the date of the string parameter (M/d/y, M-d-y).

**Query**

```
CDate('8/2/2012')
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>2012-08-02T00:00:00.000</td></tr></table>


**Assertion : MDX Equals**

```
DateTime(2012,8,2,0,0)
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Now()

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the current datetime

**Query**

```
Now()
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>2025-11-14T07:41:39.000</td></tr></table>


**Assertion : MDX Equals**

```
Now()
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Year()

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the year of the parameter date

**Query**

```
Year( DateTime(2012,8,2) )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>2012</td></tr></table>


**Assertion : MDX Equals**

```
2012
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Month()

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the month of the parameter date

**Query**

```
Month( DateTime(2012,8,2) )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>8</td></tr></table>


**Assertion : MDX Equals**

```
8
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Day()

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the day of the month of the parameter date

**Query**

```
Day( DateTime(2012,8,2) )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>2</td></tr></table>


**Assertion : MDX Equals**

```
2
```


 
</div>

                                                                                                            

### See Also


[Excel Conversion Functions](Excel%20Conversion%20Functions.md)

[Excel Numerical Functions](Excel%20Numerical%20Functions.md)

[Excel Text Functions](Excel%20Text%20Functions.md)

[Java Functions](Java%20Functions.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
